local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)


		mods = {
			{0, '*99 2x,*99 confusion,*99 drunk,*99 tipsy'},
			{32.1, '*99 -100% tiny'},
			{32.251, '*3 no tiny'},
			{36.1, '*69 tornado,*69 0.1x,*4 55% stealth,*100000 suddenoffset'},
			{60.1, '*4 no tornado,2x,*4 no stealth'},
			{64.1, '*7 no drunk,*7 no tipsy,*7 no dark,*7 no confusion,*10000 sudden,*100000 60% suddenoffset,*99 25% reverse'},
			{104, '*0.01 55% stealth'},
			{112, '*2 no stealth'},
			{124, '*3 no reverse,*3 no sudden'},
			{170, '*0.5 55% stealth'},
			{188, '*2 no stealth,*4 xmode'},
			{189, '*8 -100% xmode'},
			{190, '*8 xmode'},
			{191, '*4 no xmode'},
			{230, '*0.5 55% stealth'},
			{252, '*2 no stealth,*6 250% distant'},
			{253, '*6 250% hallway'},
			{254, '*6 250% distant'},
			{255, '*6 overhead'},
			{256, '*10 cover'},
			{304, '*99 -50% split'},
			{306, '*99 no split'},
			{317, '*99 2000% dizzy'},
			{318, '*1000 no dizzy'},
			{320, '*99 no cover'},
			--420 BLAZIT!
			{420, '-200% wave,*0.5 55% stealth'},
			{448, '*5 no wave,*2 no stealth'},
			{496, '*2 150% hallway'},
			{512, '*8 overhead,*8 dark,*8 -100% confusion,*8 -100% drunk,*8 -100% tipsy'},
			{571, '*0.5 no dark,*9999 no confusion,no drunk,no tipsy'},
			{576, '*0.6 -9000% tiny,*0.6 centered,*0.3 dark,stealth'},
			--added this so that the ending will be smooth af
			{588, '*99 200% mini,*99 2000% tiny'}
		}

StrEnd={{0,63},{512,571}}

for i,v in pairs(StrEnd) do
    for beat=v[1],v[2], 4 do
        table.insert(mods, {beat, '*99 no dark'})
		table.insert(mods, {beat + 0.25, '*3 dark'})
    end
end

for beat=64,111, 1 do
	table.insert(mods, {beat, '*10 -500% tiny'})
	table.insert(mods, {beat + 0.5, '*15 no tiny'})
end

ntiny={{256,267},{272,283},{288,303},{306,315}}

for i,v in pairs(ntiny) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, '*99 -150% tiny'})
        table.insert(mods, {beat + 0.25, '*10 no tiny'})
    end
end

stealthy={{268,271},{284,287}}

for i,v in pairs(stealthy) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, '*99 55% stealth,*99 invert'})
        table.insert(mods, {beat + 0.25, '*99 no stealth,*99 no invert'})
    end
end

dizzloop={{332,336},{348, 352},{364,368},{380,384}}

for i,v in pairs(dizzloop) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, '*4 -628% dizzy'})
        table.insert(mods, {beat + 3.5, '*20 no dizzy'})
    end
end


		local bouncePlyrs = function()
			p1:bounce():effectmagnitude(0, -75, 0):effectclock('beat'):effectperiod(1)
			p2:bounce():effectmagnitude(0, -75, 0):effectclock('beat'):effectperiod(1)
		end
		
		local bouncePlyrsX2 = function()
			p1:bounce():effectmagnitude(0, -75, 0):effectclock('beat'):effectperiod(0.5)
			p2:bounce():effectmagnitude(0, -75, 0):effectclock('beat'):effectperiod(0.5)
		end
		
		local bouncePlyrsX3 = function()
			p1:bounce():effectmagnitude(0, -75, 0):effectclock('beat'):effectperiod(0.25)
			p2:bounce():effectmagnitude(0, -75, 0):effectclock('beat'):effectperiod(0.25)
		end

		local stopEffect = function()
			p1:stopeffect()
			p2:stopeffect()
			screen:stopeffect()
		end
		
		local screenVibrate = function()
			screen:vibrate()
		end
		
		local screenVibH = function()
			screen:vibrate():effectmagnitude(40, 40, 40)
		end

		local bobPlyrs = function()
			for i=1, #players do
				players[i]
					:bob()
					:effectmagnitude(0, 0, 360)
					:effectclock('beat')
					:effectperiod(0.75)
			end
		end

		local yeah = function()
			for i=1, #players do
				players[i]
					:smooth(0.1)
					:skewx(1)
			end
		end
		
		local yeah2 = function()
			for i=1, #players do
				players[i]
					:smooth(0.1)
					:skewx(-1)
			end
		end
		
		local yea1 = function()
			for i=1, #players do
				players[i]
					:smooth(0.1)
					:zoomy(2)
			end
		end
		
		local yea2 = function()
			for i=1, #players do
				players[i]
					:smooth(0.1)
					:zoomy(0.5)
			end
		end
		
		local ye1 = function()
			for i=1, #players do
				players[i]
					:smooth(0.3)
					:rotationz(40)
			end
		end
		
		local ye2 = function()
			for i=1, #players do
				players[i]
					:smooth(0.3)
					:rotationz(-40)
			end
		end

		local resetPlyrs = function()
			for i=1, #players do
				players[i]
					:rotationx(0)
					:rotationy(0)
					:rotationz(0)
					:zoom(1)
					:zoomz(1)
					:zoomy(1)
					:skewx(0)
					:zoomx(1)
			end
		end

		actorCmds = {
			{64, bouncePlyrs},
			{112, bouncePlyrsX2},
			{120, bouncePlyrsX3},
			{124, stopEffect},
			{128, bobPlyrs},
			{188, resetPlyrs},
			{188.1, stopEffect},
			{192, bobPlyrs},
			{252, resetPlyrs},
			{252.1, stopEffect},
			{320, bouncePlyrsX2},
			{320.1, screenVibrate},
			{448, stopEffect},
			{448.1, bouncePlyrs},
			{464, screenVibrate},
			{508, screenVibH},
			{512, resetPlyrs},
			{512.1, stopEffect}
		}
		
for beat=128,187, 1 do
	table.insert(actorCmds, {beat, yea1})
	table.insert(actorCmds, {beat + 0.167, yea2})
end
		
for beat=192,251, 1 do
	table.insert(actorCmds, {beat, yeah})
	table.insert(actorCmds, {beat + 0.5, yeah2})
end

for beat=464,509, 1 do
	table.insert(actorCmds, {beat, ye1})
	table.insert(actorCmds, {beat, ye2})
end

		-- for edit mode
		-- for i=#mods, 1, -1 do
		-- 	if GAMESTATE:GetSongBeat() > mods[i][1] then
		-- 		table.remove(mods, i)
		-- 	end
		-- end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					-- this is horrible, like, no
					-- only keeping for historical purposes
					-- for modname, values in pairs(mod) do
					-- 	if p1options[modname] then
					-- 		p1options[modname](p1options, unpack(values))
					-- 		p2options[modname](p2options, unpack(values))
					-- 	end
					-- end

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end
			
			for i=1,2 do
				SCREENMAN:GetTopScreen():GetChild('LifeP'..i):visible(false);
                SCREENMAN:GetTopScreen():GetChild('ScoreP'..i):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Overlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Underlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('BPMDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('StageDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('SongTitle'):visible(false);
				SCREENMAN:GetTopScreen():GetChild("SongMeterDisplay" .. PlayerNumberToString(i-1)):visible(false);
				SCREENMAN:GetTopScreen():GetChild("StepsDisplay" .. PlayerNumberToString(i-1)):visible(false);
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,
	
	Def.Sprite{
    InitCommand= cmd(hibernate,144.1;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoom,9999;blend,'invertdest'),
    OnCommand= cmd(),
    Texture= "white.png",
  },

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
}
